// cmdline - Kommandoeingabe ueber die Konsole
//
// (c) Stefan Krauss, 70437 Stuttgart
// 
// Lizenz: Nutzung und Weitergabe nach der GNU General Public License (GPL), Version 3
//         Es wird keinerlei Haftung oder Gewaehrleistung uebernommen, siehe GPL!

#include "stdafx.h"

// globale Variable fuer Zustand
unsigned int param;

// gibt eine kurze Beschreibung der Kommandozeilenbedienung aus
void cmddescr()
{
	printf("Kommando mit <Enter> bestaetigen oder mit <Escape> abbrechen\n");
	printf("  l            -> letzte verwendete mfx-Nummer ausgeben\n");
	printf("  v <mfx-Nr.>  -> Richtungswechsel mfx-Lok vorwaerts\n");
	printf("  r <mfx-Nr.>  -> Richtungswechsel mfx-Lok rueckwaerts\n");
	printf("  x            -> Programm beenden\n\n");
}

// liest die eingegebenen Buchstaben und erkennt Kommandos
unsigned int cmdinput()
{
	int key;
	unsigned int retval = 0;
	unsigned int state = 1; // 0 = fertig, 1 = Warte auf Kommando, 2 = Warte auf Zahl 
	unsigned int nr = 0;

	printf ("> ");
	do 
	{
		key = _getch();
		if (state == 1)
		{
			switch (key)
			{
			case 'v':
			case 'V':
				_putch(key);
				retval = 2;
				state = 2;
				break;
			case 'l':
			case 'L':
				_putch(key);
				retval = 1;
				break;
			case 'r':
			case 'R':
				_putch(key);
				retval = 3;
				state = 2;
				break;
			case 'x':
			case 'X':
				_putch(key);
				retval = 0;
				break;
			case 13: // <Return>
				state = 0;
				printf("\n");
				break;
			case 27: // <Escape>
				nr = 0;
				retval = 0;
				state = 1;
				printf("\n> ");
				break;
			default:
				// andere Zeichen ignorieren
				break;
			}
		}
		else if (state == 2)
		{
			switch (key)
			{
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				_putch(key);
				nr = nr * 10 + (key - 48);
				break;
			case ' ':
				_putch(key);
				break;
			case 13: // <Return>
				if (nr == 0)
				{
					printf("\nFehleingabe: Loknummer 0 nicht erlaubt!\n> ");
					nr = 0;
					retval = 0;
					state = 1;
				}
				else
				{
					param = nr;
					state = 0;
					printf("\n");
				}
				break;
			case 27: // <Escape>
				nr = 0;
				retval = 0;
				state = 1;
				printf("\n> ");
				break;
			default:
				// ignorieren
				break;
			}
		}
		// keine anderen states moeglich
	}
	while (state > 0);
	return retval;
}

// gibt den beim Kommando eingegebenen Parameter aus (mfx-Nummer)
unsigned int cmdparam()
{
	return param;
}

