// cfgfile - Verwaltung der Konfigurationsdatei
//
// (c) Stefan Krauss, 70437 Stuttgart
// 
// Lizenz: Nutzung und Weitergabe nach der GNU General Public License (GPL), Version 3
//         Es wird keinerlei Haftung oder Gewaehrleistung uebernommen, siehe GPL!

#include "stdafx.h"

// ein Teil der alten C-Datei-Funktionen wird vom Compiler als eventuell unsicher bemaengelt,
// diese Warnung wird hiermit abgeschaltet
#pragma warning(disable : 4996)

// Name der Konfigurationsdatei
#define CFGFILE "gbox2eth.cfg"

// globale Variablen
unsigned int comnr = 1;
char ipnr_in[17] = "";
char ipnr_out[17] = "";
unsigned int mfxnr = 0;

// gibt 1 zurueck, wenn die Konfigurationsdatei existiert
int cfgexists()
{
	FILE* fd;


	fd = fopen(CFGFILE, "r");
	if (fd == NULL)
	{
		return 0;
	}
	else
	{
		fclose(fd);
		return 1;
	}
}

// Einlesen der Konfigurationsdatei; Datei muss existieren
void readcfgfile()
{
	FILE* fd;
	int lineno = 0;
	char line[256];
	int error = 0; // 1 = es wurde ein Fehler beim Einlesen entdeckt

	if ((fd = fopen(CFGFILE, "r")) == NULL)
	{
		printf("Konfigurationsdatei existiert nicht oder laesst sich nicht oeffnen!\n");
	}
	else
	{
		while (fgets(line, sizeof(line), fd) != NULL)
		{
			lineno++;
			switch (lineno)
			{
			case 1: // in Zeile 1 steht die COM-Port-Nummer
				error = sscanf(line, "%u\n", &comnr);
				break;
			case 2: // in Zeile 2 steht die IP-Adresse fuer eingehende UDP-Pakete
				error = sscanf(line, "%255s\n", &ipnr_in);
				break;
			case 3: // in Zeile 3 steht die IP-Adresse fuer ausgehende UDP-Pakete
				error = sscanf(line, "%255s\n", &ipnr_out);
				break;
			default: // alle weiteren Zeilen enthalten eine Zahl, die die letzte mfx-Nummer anzeigt
				error = sscanf(line, "%u\n", &mfxnr);
				break;
			}
			if (error < 0)
			{
				printf("Fehler beim Einlesen der Konfigurationsdatei, Zeile %d!\n", lineno);
			}
		}
	}
}

// legt die Konfigurationsdatei neu an; dabei wird aber die hoechste mfx-Nummer aus der alten Datei
// uebernommen, falls diese existiert
void createcfgfile(char* p1, char* p2)
{
	FILE* fd;

	mfxnr = 0;
	if (cfgexists())
	{
		readcfgfile();
	}
	if ((fd = fopen(CFGFILE, "w")) == NULL)
	{
		printf("Konfigurationsdatei konnte nicht angelegt werden!\n");
	}
	else
	{
		if (sscanf(p1, "%d", &comnr) != 1)
		{
			printf("Aufruf-Parameter 1 (COM-Port) konnte nicht interpretiert werden!\n");
			printf("Es wird COM-Port 1 oder der bisherige COM-Port verwendet!\n");
			comnr = 1;
		}
		if (strlen(p2) > 16)
		{
			printf("Aufruf-Parameter 2 (IP-Adresse) ist zu lang!\n");
			printf("Es wird 127.0.0.1 verwendet!\n");
			strcpy(ipnr_in, "127.0.0.1");
			strcpy(ipnr_out, "127.0.0.1");
		}
		else
		{
			strcpy(ipnr_in, p2);
			strcpy(ipnr_out, p2);
		}
		fprintf(fd, "%d\n%s\n%s\n%d\n", comnr, ipnr_in, ipnr_out, mfxnr);
		fclose(fd);
	}
}

// legt die Konfigurationsdatei neu an; dabei wird aber die hoechste mfx-Nummer aus der alten Datei
// uebernommen, falls diese existiert; Variante mit unterschiedlicher IP-Adresse fuer Sende- und
// Empfangsrichtung
void createcfgfile(char* p1, char* p2, char* p3)
{
	FILE* fd;

	mfxnr = 0;
	if (cfgexists())
	{
		readcfgfile();
	}
	if ((fd = fopen(CFGFILE, "w")) == NULL)
	{
		printf("Konfigurationsdatei konnte nicht angelegt werden!\n");
	}
	else
	{
		if (sscanf(p1, "%d", &comnr) != 1)
		{
			printf("Aufruf-Parameter 1 (COM-Port) konnte nicht interpretiert werden!\n");
			printf("Es wird COM-Port 1 oder der bisherige COM-Port verwendet!\n");
			comnr = 1;
		}
		if (strlen(p2) > 16)
		{
			printf("Aufruf-Parameter 2 (IP-Adresse fuer eingehende UDP-Pakete) ist zu lang!\n");
			printf("Es wird 127.0.0.1 verwendet!\n");
			strcpy(ipnr_in, "127.0.0.1");
		}
		else
		{
			strcpy(ipnr_in, p2);
		}
		if (strlen(p3) > 16)
		{
			printf("Aufruf-Parameter 3 (IP-Adresse fuer ausgehende UDP-Pakete) ist zu lang!\n");
			printf("Es wird 127.0.0.1 verwendet!\n");
			strcpy(ipnr_out, "127.0.0.1");
		}
		strcpy(ipnr_out, p3);
		fprintf(fd, "%d\n%s\n%s\n%d\n", comnr, ipnr_in, ipnr_out, mfxnr);
		fclose(fd);
	}
}

// oeffnet die Konfigurationsdatei und liest die Daten ein; Fehlermeldung, falls die Datei nicht
// existiert, Rueckgabe von 0
int opencfgfile()
{
	if (cfgexists())
	{
		readcfgfile();
		if (strcmp(ipnr_in, ipnr_out) == 0)
		{
			printf("COM-Port: %d, IP-Adresse: %s\n", comnr, ipnr_in);
		}
		else
		{
			printf("COM-Port: %d, IP-Adresse (lesend): %s, IP-Adresse (schreibend): %s\n", comnr, ipnr_in, ipnr_out);
		}
		return 1;
	}
	else
	{
		printf("Konnte Konfigurationsdatei nicht oeffnen!\n");
		return 0;
	}
}

unsigned int comchannel()
{
	return comnr;
}

char* ipnumber_in()
{
	return ipnr_in;
}

char* ipnumber_out()
{
	return ipnr_out;
}

unsigned int lastmfxnr()
{
	return mfxnr;
}

unsigned int nextmfxnr()
{
	FILE* fd;

	mfxnr = mfxnr + 1;
	if ((fd = fopen(CFGFILE, "a")) == NULL)
	{
		printf("Konfigurationsdatei existiert nicht oder kann nicht beschrieben werden!\n");
	}
	else
	{
		fprintf(fd, "%d\n", mfxnr);
		fclose(fd);
	}
	return mfxnr;
}
